<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Doctrine\DBAL\Connection;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_ergebnis_archiv_navigation",
 *     category="ltvberlin",
 *     template="mod_ltvberlin_ergebnis_archiv_navigation",
 *     renderer="forward"
 * )
 */
class ErgebnisArchivNavigationFrontendModuleController extends AbstractErgebnisFrontendModuleController
{
    public function __construct(Connection $defaultConnection, LoggerInterface $contaoErrorLogger)
    {
        parent::__construct($defaultConnection, $contaoErrorLogger);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/ltvberlin/scripts/ergebnis-archiv-navigation.js|1';

        $jahre = [];
        $jahreszahlen = $this->jahreLaden();
        $page = $this->getPageModel();
        if ($page) {
            $jahre = array_map(function ($jahr) use ($page) {
                return [$jahr, $this->isUseAutoItem() ? $page->getFrontendUrl("/$jahr") : $page->getFrontendUrl() . "?jahr=$jahr"];
            }, $jahreszahlen);
        }
        $template->aktuellesJahr = $this->getRequestedYear($request);
        $template->jahre = $jahre;
        return $template->getResponse();
    }
}
