<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Doctrine\DBAL\Connection;
use LTVBerlin\Contao\LTVBerlinBundle\Model\ErgebnisModel;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_ergebnis_aktuell",
 *     category="ltvberlin",
 *     template="mod_ltvberlin_ergebnis_aktuell",
 *     renderer="forward"
 * )
 */
class ErgebnisAktuellFrontendModuleController extends AbstractErgebnisFrontendModuleController
{
    public function __construct(Connection $defaultConnection, LoggerInterface $contaoErrorLogger)
    {
        parent::__construct($defaultConnection, $contaoErrorLogger);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $ergebnisse = [];
        if ($model->verband_ergebnis_anzahl > 0 && $model->verband_ergebnis_alter > 0) {
            $minTimestamp = time() - ($model->verband_ergebnis_alter * 10 * 24 * 60 * 60);
            $options = array(
                'limit' => $model->verband_ergebnis_anzahl,
                'order' => 'tstamp DESC',
            );
            $table = ErgebnisModel::getTable();
            $records = ErgebnisModel::findBy(["$table.tstamp >= ?"], [$minTimestamp], $options);
            if ($records) {
                $ergebnisTemplate = $model->verband_ergebnis_template ?: 'ergebnis_default';
                while ($records->next()) {
                    $ergebnisse[] = $this->parseErgebnis($records->current(), $ergebnisTemplate, (int) $model->jumpTo);
                }
            }
        }
        $template->ergebnisse = new \ArrayIterator($ergebnisse);
        return $template->getResponse();
    }
}
