<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Utils;

use Contao\Controller;
use Contao\MemberGroupModel;
use Contao\Message;
use HHIT\VerbandVereinBundle\Models\VereinModel;

class MemberGroupUtils
{

    public function synchronize()
    {
        $count = 0;
        $created = 0;
        $deleted = 0;

        $seen = [];

        $verein = VereinModel::findAll();
        while ($verein->next()) {
            $memberGroup = MemberGroupModel::findOneBy('verband_verein', $verein->id);
            if ($memberGroup == null) {
                $memberGroup = new MemberGroupModel();
                $memberGroup->verband_verein = $verein->id;
                $created++;
            }
            $memberGroup->name = VereinModel::createMemberGroupName($verein->verein);
            $memberGroup->tstamp = time();
            $memberGroup->save();

            $count++;
            $seen[] = $memberGroup->id;
        }

        $memberGroup = MemberGroupModel::findAll();
        while ($memberGroup->next()) {
            if ($memberGroup->verband_verein > 0) {
                if (!in_array($memberGroup->id, $seen)) {
                    $memberGroup->delete();
                    $deleted++;
                }
            }
        }

        Message::addInfo(sprintf('%1$s Mitgliedergruppen synchronisiert (%2$s neu, %3$s gelöscht).', $count, $created, $deleted));

        Controller::redirect(Controller::getReferer());
    }
}
