<?php

namespace HHIT\VerbandVereinBundle\Widgets;

use Contao\StringUtil;
use Contao\Widget;

/**
 * @property-read bool $multiple
 */
class CheckboxGroup extends Widget
{

    /**
     * Template
     * @var string
     */
    protected $strTemplate = 'widget_checkboxgroup';

    /**
     * Add specific attributes
     * @param string
     * @param mixed
     */
    public function __set($strKey, $varValue)
    {
        switch ($strKey) {
            case 'options':
                $this->arrOptions = StringUtil::deserialize($varValue);
                break;

            default:
                parent::__set($strKey, $varValue);
                break;
        }
    }

    public function generate()
    {
        $arrOptions = array();
        foreach ($this->arrOptions as $i => $objOption) {
            $arrOptions[] = $this->generateCheckbox($objOption, $i);
        }
        return '<div class="checkboxgroup">' . implode("", $arrOptions) . '</div>';
    }

    protected function generateCheckbox($objOption, $i)
    {
        return sprintf('<span><input type="checkbox" name="%s" id="opt_%s" class="tl_checkbox" value="%s"%s%s> <label for="opt_%s">%s</label></span>',
            $this->strName . ($this->multiple ? '[]' : ''),
            $this->strId . '_' . $i,
            ($this->multiple ? specialchars($objOption->value) : 1),
            ($this->isChecked($objOption) ? 'checked="checked"' : ''),
            $this->getAttributes(),
            $this->strId . '_' . $i,
            $objOption->label);
    }

    protected function isChecked($objOption)
    {
        if (is_array($this->varValue)) {
            return in_array($objOption->value, $this->varValue);
        } else {
            return $this->varValue == $objOption->value;
        }
    }
}
