<?php

namespace HHIT\VerbandVereinBundle\Models;

use Contao\Idna;
use Contao\Model;
use Contao\StringUtil;
use Model\Collection;

/**
 * Modell für einen Verein
 *
 * @property int $id
 * @property int $tstamp
 * @property string $verein
 * @property string $alias
 * @property int $vereinsNrDtv
 * @property int $vereinsNrLsb
 * @property string $adresse
 * @property string|null $telefon
 * @property string|null $fax
 * @property string|null $email
 * @property string|null $homepage
 * @property string|null $standorte
 * @property string|null $trainingsstaetten
 * @property string|null $aktivitaeten
 * @property string|null $weitere_aktivitaeten
 * @property string|null $ansprechpartner
 */
class VereinModel extends Model
{

    protected static $strTable = 'tl_verband_verein';

    public function __get($strKey)
    {
        switch ($strKey) {
            case 'homepage':
                $value = parent::__get($strKey);
                if ($value && !preg_match('/^http(s?):\/\//', $value)) {
                    return 'http://' . parent::__get($strKey);
                } else {
                    return $value;
                }
            default:
                return parent::__get($strKey);
        }
    }

    public function getHumanReadableHomepage(): ?string
    {
        $url = $this->homepage;
        if ($url) {
            return rtrim(preg_replace('/^http(s?):\/\//', '', Idna::decodeUrl($url)), '/\s');
        } else {
            return null;
        }
    }

    public function getEncodedEmail(): ?string
    {
        $email = $this->email;
        if ($email) {
            return StringUtil::encodeEmail($email);
        } else {
            return null;
        }
    }

    public static function allAsSelectOptions()
    {
        $options = array("0" => "(kein Verein)");
        $objVereine = static::findAll(array('order' => 'verein ASC'));
        if ($objVereine != null && $objVereine->count() > 0) {
            while ($objVereine->next()) {
                $verein = $objVereine->current();
                $options[$verein->id] = $verein->verein;
            }
        }
        return $options;
    }

    public static function suchen($vereinsname, $standorte, $aktivitaeten)
    {
        $search = $vereinsname != null && trim($vereinsname) != "" ? "%" . strtolower($vereinsname) . "%" : "%";
        $arrColumns = ["LOWER(verein) LIKE ?"];
        $arrValues = [$search];

        if ($standorte != null && is_array($standorte)) {
            if (count($standorte) > 0) {
                $arrColumns[] = "(standorte LIKE ?" . str_repeat(" OR standorte LIKE ?", count($standorte) - 1) . ")";
                foreach ($standorte as $s) {
                    $arrValues[] = "%" . serialize((string)$s) . "%";
                }
            }
        }
        if ($aktivitaeten != null && is_array($aktivitaeten)) {
            if (count($aktivitaeten) > 0) {
                $arrColumns[] = "(aktivitaeten LIKE ?" . str_repeat(" OR aktivitaeten LIKE ?", count($aktivitaeten) - 1) . ")";
                foreach ($aktivitaeten as $a) {
                    $arrValues[] = "%" . serialize((string)$a) . "%";
                }
            }
        }
        $arrOptions = array('order' => 'verein ASC');
        return static::findBy($arrColumns, $arrValues, $arrOptions);
    }

    /**
     * @return Collection
     */
    public function getAktivitaeten()
    {
        return $this->getRelated('aktivitaeten');
    }

    /**
     * @return Collection
     */
    public function getStandorte()
    {
        return $this->getRelated('standorte');
    }

    /**
     * @return string[]
     */
    public function getStandorteAsString(): array
    {
        $standortNamen = [];
        $standorte = $this->getStandorte();
        if ($standorte != null) {
            while ($standorte->next()) {
                $standortNamen[] = $standorte->standort;
            }
        }
        return $standortNamen;
    }

    public function hatAktivitaeten(): bool
    {
        return ($this->getAktivitaeten() != null && $this->getAktivitaeten()->count() > 0) || $this->weitere_aktivitaeten;
    }

    public function hatKontakte(): bool
    {
        return $this->telefon || $this->fax || $this->email;
    }

    public function hatStandorte(): bool
    {
        return $this->getStandorte() != null && $this->getStandorte()->count() > 0;
    }

    public static function createMemberGroupName($strName)
    {
        return "VDZ " . $strName;
    }
}
