<?php

$GLOBALS['TL_DCA']['tl_verband_verein'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'alias' => 'index',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('verein'),
            'flag' => 1,
            'panelLayout' => 'filter;sort,search,limit'
        ),
        'label' => array
        (
            'fields' => array('verein'),
            'format' => '%s'
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            ),
            'synchronizeMemberGroups' => array
            (
                'label' => "Mitgliedergruppen synchronisieren",
                'href' => 'key=synchronizeMemberGroups',
                'icon' => 'mgroup.gif',
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if (!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\')) return false; Backend.getScrollOffset();"'
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{basisdaten_legende},verein,alias,vereinsNrDtv,vereinsNrLsb;{adresse_legende},adresse;{kontakte_legende},telefon,fax,email,homepage;{orte_legende},standorte,trainingsstaetten;{aktivitaeten_legende},aktivitaeten,weitere_aktivitaeten;{ansprechpartner_legende},ansprechpartner;'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'verein' => array
        (
            'sql' => "varchar(128) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['verein'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['verein'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'maxlength' => 128, 'tl_class' => 'long'),
        ),
        'alias' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['alias'],
            'exclude' => false,
            'search' => false,
            'inputType' => 'text',
            'eval' => array('rgxp' => 'alias', 'unique' => true, 'maxlength' => 192, 'tl_class' => 'long'),
            'sql' => "varbinary(192) NOT NULL default ''"
        ),
        'vereinsNrDtv' => array
        (
            'sql' => "int(10) unsigned NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['vereinsNrDtv'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['vereinsNrDtv'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'rgxp' => 'digit', 'tl_class' => 'w50'),
        ),
        'vereinsNrLsb' => array
        (
            'sql' => "int(10) unsigned NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['vereinsNrLsb'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['vereinsNrLsb'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'rgxp' => 'digit', 'tl_class' => 'w50'),
        ),
        'adresse' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['adresse'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['adresse'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => true, 'style' => 'height:60px'),
        ),
        'telefon' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['telefon'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['telefon'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'fax' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['fax'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['fax'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'email' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['email'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['email'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'rgxp' => 'email', 'tl_class' => 'w50'),
        ),
        'homepage' => array
        (
            'sql' => "varchar(255) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['homepage'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['homepage'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'maxlength' => 255, 'rgxp' => 'url', 'tl_class' => 'w50'),
        ),
        'standorte' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['standorte'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['standorte'],
            'exclude' => false,
            'inputType' => 'checkboxWizard',
            'foreignKey' => 'tl_verband_standort.standort',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'multiple' => true),
            'relation' => array('type' => 'hasMany', 'load' => 'lazy'),
        ),
        'trainingsstaetten' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['trainingsstaetten'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['trainingsstaetten'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('allowHtml' => true, 'rte' => 'tinyMCE'),
        ),
        'aktivitaeten' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['aktivitaeten'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['aktivitaeten'],
            'exclude' => false,
            'inputType' => 'checkboxWizard',
            'foreignKey' => 'tl_verband_aktivitaet.aktivitaet',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'multiple' => true),
            'relation' => array('type' => 'hasMany', 'load' => 'lazy'),
        ),
        'weitere_aktivitaeten' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['weitere_aktivitaeten'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['weitere_aktivitaeten'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('allowHtml' => true, 'rte' => 'tinyMCE'),
        ),
        'ansprechpartner' => array
        (
            'sql' => "text NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_verein']['ansprechpartner'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_verein']['ansprechpartner'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('allowHtml' => true, 'rte' => 'tinyMCE'),
        ),
    )
);
