<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use HHIT\VerbandVereinBundle\Models\AktivitaetModel;
use HHIT\VerbandVereinBundle\Models\StandortModel;
use HHIT\VerbandVereinBundle\Models\VereinModel;

/**
 * @FrontendModule("verband_verein_suche",
 *  category="verband",
 *  template="mod_verband_verein_suche",
 *  renderer="forward"
 * )
 */
class VereinssucheFrontendModuleController extends AbstractVereinFrontendModuleController
{
    use GenerateVereinLinkTrait;

    private static $formId = 'mod_verband_verein_suche';

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $template->formularAnzeigen = true;
        $template->formId = self::$formId;

        if ($request->isMethod('post') && $request->request->get('FORM_SUBMIT', null) === self::$formId) {
            $template->formularAnzeigen = false;
            $vereinsname = $request->request->get('vereinsname', '');
            $standorte = $request->request->get('standorte', []);
            $aktivitaeten = $request->request->get('aktivitaeten', []);

            $vereine = [];
            $collection = $this->framework->getAdapter(VereinModel::class)->suchen($vereinsname, $standorte, $aktivitaeten);
            if ($collection) {
                while ($collection->next()) {
                    $verein = $collection->current();
                    $verein->link = $this->generateLink($collection->current(), $model, $this->isUseAutoItem());
                    $vereine[] = $verein;
                }
            }
            $template->vereine = $vereine;
        } else {
            $template->aktivitaeten = AktivitaetModel::all();
            $template->standorte = StandortModel::all();
            $template->label_vereinsname = $GLOBALS['TL_LANG']['mod_verband_verein_suche']['label_verein'];
            $template->label_aktivitaeten = $GLOBALS['TL_LANG']['mod_verband_verein_suche']['label_aktivitaeten'];
            $template->label_standorte = $GLOBALS['TL_LANG']['mod_verband_verein_suche']['label_standorte'];
            $template->label_suchen = $GLOBALS['TL_LANG']['mod_verband_verein_suche']['label_suchen'];
        }

        return $template->getResponse()->setPrivate();
    }
}
