<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use HHIT\VerbandVereinBundle\Models\VereinModel;

/**
 * @FrontendModule("verband_verein_liste",
 *  template="mod_verband_verein_liste",
 *  category="verband",
 *  renderer="forward"
 * )
 */
class VereinslisteFrontendModuleController extends AbstractVereinFrontendModuleController
{
    use GenerateVereinLinkTrait;

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $collection = VereinModel::findAll(array('order' => 'verein ASC'));
        $vereine = [];
        while ($collection->next()) {
            $verein = $collection->current();
            $verein->link = $this->generateLink($verein, $model, $this->isUseAutoItem());
            $vereine[] = $verein;
        }
        $template->vereine = $vereine;

        return $template->getResponse()->setPrivate();
    }
}
