<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Input;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use HHIT\VerbandVereinBundle\Models\VereinModel;

/**
 * @FrontendModule("verband_verein_leser",
 *  category="verband",
 *  template="mod_verband_verein_leser",
 *  renderer="forward"
 * )
 */
class VereinsleserFrontendModuleController extends AbstractVereinFrontendModuleController
{
    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $alias = $this->getRequestedAlias();
        if (!$alias) {
            throw $this->createNotFoundException();
        }

        $adapter = $this->framework->getAdapter(VereinModel::class);
        /**
         * @var $verein VereinModel
         */
        $verein = $adapter->findByIdOrAlias($alias);
        if (!$verein) {
            throw $this->createNotFoundException();
        }

        $this->getPageModel()->title = $verein->verein;
        $template->verein = $verein;

        return $template->getResponse()->setPrivate();
    }

    private function getRequestedAlias(): ?string
    {
        $input = $this->framework->getAdapter(Input::class);
        return $this->isUseAutoItem() ? $input->get('auto_item') : $input->get('items');
    }
}
