<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Controller\FrontendModule;

use Contao\ModuleModel;
use Contao\PageModel;
use Contao\StringUtil;
use HHIT\VerbandVereinBundle\Models\VereinModel;

trait GenerateVereinLinkTrait
{

    public function generateLink(VereinModel $verein, ModuleModel $model, $useAutoItems): ?string
    {
        $url = $this->getFrontendUrl($verein, $model, $useAutoItems);
        if ($url) {
            return sprintf('<a href="%1$s" title="%2$s">%2$s</a>', $url, StringUtil::specialchars($verein->verein));
        } else {
            return null;
        }
    }

    private function getFrontendUrl(VereinModel $verein, ModuleModel $model, $useAutoItems): ?string
    {
        if ($model->jumpTo && ($targetPage = $model->getRelated('jumpTo'))) {
            /**
             * @var PageModel $targetPage
             */
            return $targetPage->getFrontendUrl($useAutoItems ?
                "/{$verein->alias}" : "/items/{$verein->alias}");
        } else {
            return null;
        }
    }
}
