<?php
declare(strict_types=1);

namespace HHIT\VerbandVereinBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;

abstract class AbstractVereinFrontendModuleController extends AbstractFrontendModuleController
{
    protected ContaoFramework $framework;

    public function __construct(ContaoFramework $framework)
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
    }

    protected function isUseAutoItem(): bool
    {
        return (bool)$this->getConfig()->get('useAutoItem');
    }

    /**
     * @return Config
     */
    protected function getConfig()
    {
        return $this->framework->getAdapter(Config::class);
    }
}
