<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Model;

use Contao\Model;
use Contao\StringUtil;

/**
 * Repr&auml;sentiert eine Person im Verband.
 *
 * @package HHIT\VerbandOrgBundle\Model
 *
 * @property string|null $adresse Adresse
 * @property string|null $email E-Mailadresse
 * @property-read string|null $encodedEmail kodierte E-Mailadresse
 * @property string|null $fax Fax-Nr.
 * @property string|null $land Land
 * @property string|null $vorname Vorname
 * @property string $nachname Nachname
 * @property-read string $name Vor- und Nachname der Person
 * @property string|null $ort Ort
 * @property string|null $plz PLZ
 * @property string|null $singleSRC UUID des Bildes (bin&auml;r)
 * @property string|null $strasse Stra&szlig;e
 * @property string|null $tel_mobil Telefon mobil
 * @property string|null $tel_geschaeftlich Telefon gesch&auml;ftlich
 * @property string|null $tel_privat Telefon privat
 * @property string|null $zusatz Zusatzangabe für Adresse, z.B. c/o
 */
class PersonModel extends Model
{

    protected static $strTable = 'tl_verband_person';

    public static function getTable(): string
    {
        return self::$strTable;
    }

    public function __get($key)
    {
        switch ($key) {
            case 'name':
                if ($this->vorname) {
                    return $this->vorname . " " . $this->nachname;
                } else {
                    return $this->nachname;
                }
            case 'encodedEmail':
                if ($this->email) {
                    return StringUtil::encodeEmail($this->email);
                } else {
                    return null;
                }
            default:
                return parent::__get($key);
        }
    }

    public function getAdresse($glue): string
    {
        $plzOrt = "";
        if ($this->plz != null && trim($this->plz) != "") {
            $plzOrt .= $this->plz;
        }
        if ($this->ort != null && trim($this->ort) != "") {
            $plzOrt .= " " . $this->ort;
        }

        $tokens = array($this->zusatz, $this->adresse, $this->strasse, $plzOrt);
        $components = array();
        foreach ($tokens as $token) {
            if ($token != null && trim($token) != "") {
                $components[] = $token;
            }
        }
        return implode($glue, $components);
    }
}
