<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Model;

use Contao\Model;
use Contao\Model\Collection;

/**
 * Repr&auml;sentiert ein Gremium im Verband.
 *
 * @package HHIT\VerbandOrgBundle\Model
 *
 * @property Collection $mitglieder Funktionen die zum Gremium geh&ouml;ren
 * @property string $gremium Name des Gremiums
 * @property-read string $name Name des Gremiums
 */
class GremiumModel extends Model
{

    protected static $strTable = 'tl_verband_gremium';

    public function __get($key)
    {
        switch ($key) {
            case 'mitglieder':
                return $this->getRelated('funktionen');
            case 'name':
                return $this->gremium;
            default:
                return parent::__get($key);
        }
    }

}
