<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Model;

use Contao\Model;

/**
 * Repr&auml;sentiert eine Funktion im Verband, die durch eine Person wahrgenommen wird.
 *
 * @package HHIT\VerbandOrgBundle\Model
 *
 * @property string $funktion_name Name der Funktion
 * @property string $funktion_intern interner Name der Funktion
 * @property-read PersonModel|null $person Daten der Person
 * @property-read bool $besetzt Funktion besetzt
 * @property-read string $name Name der Funktion
 * @property-read string $nameIntern interner Name der Funktion
 * @property-read string $alias Alias
 */
class FunktionModel extends Model
{

    protected static $strTable = 'tl_verband_funktion';

    public function __get($key)
    {
        switch ($key) {
            case 'person':
                return $this->getRelated('person');
            case 'besetzt':
                return $this->getRelated('person') !== null;
            case 'name':
                return $this->funktion_name;
            case 'nameIntern':
                return $this->funktion_intern;
            default:
                return parent::__get($key);
        }
    }

    public function getAlias(): string
    {
        if ($this->alias) {
            return $this->alias;
        } else {
            return "{$this->id}";
        }
    }
}
