<?php

System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_verband_person'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ctable' => array('tl_content'),
        'switchToEdit' => true,
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary'
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('nachname'),
            'flag' => 1,
            'panelLayout' => 'filter;sort,search,limit',
        ),
        'label' => array
        (
            'fields' => array('nachname', 'vorname'),
            'format' => '%s, %s'
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['edit'],
                'href' => 'table=tl_content',
                'icon' => 'edit.gif'
            ),
            'editheader' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['editheader'],
                'href' => 'act=edit',
                'icon' => 'header.gif'
            ),
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{name_legende},vorname,nachname,zusatz;{adresse_legende},adresse,strasse,plz,ort,land;{kontakte_legende},tel_privat,tel_geschaeftlich,tel_mobil,fax,email;{bild_legende},singleSRC'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'vorname' => array
        (
            'sql' => "varchar(64) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['vorname'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['vorname'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'minlength' => 1, 'maxlength' => 64, 'tl_class' => 'w50')
        ),
        'nachname' => array
        (
            'sql' => "varchar(64) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['nachname'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['nachname'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'minlength' => 1, 'maxlength' => 64, 'tl_class' => 'w50')
        ),
        'zusatz' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['zusatz'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['zusatz'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50')
        ),
        'adresse' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['adresse'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['adresse'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50')
        ),
        'strasse' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['strasse'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['strasse'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50')
        ),
        'plz' => array
        (
            'sql' => "varchar(12) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['plz'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['plz'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 12, 'tl_class' => 'w50')
        ),
        'ort' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['ort'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['ort'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50')
        ),
        'land' => array
        (
            'sql' => "varchar(64) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['land'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['land'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 64, 'tl_class' => 'w50')
        ),
        'tel_privat' => array
        (
            'sql' => "varchar(36) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_privat'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_privat'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 36, 'tl_class' => 'w50')
        ),
        'tel_geschaeftlich' => array
        (
            'sql' => "varchar(36) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_geschaeftlich'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_geschaeftlich'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 36, 'tl_class' => 'w50')
        ),
        'tel_mobil' => array
        (
            'sql' => "varchar(36) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_mobil'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['tel_mobil'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 36, 'tl_class' => 'w50')
        ),
        'fax' => array
        (
            'sql' => "varchar(36) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['fax'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['fax'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 36, 'tl_class' => 'w50')
        ),
        'email' => array
        (
            'sql' => "varchar(64) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['email'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['email'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 64, 'rgxp' => 'email', 'tl_class' => 'w50')
        ),
        'singleSRC' => array
        (
            'sql' => "binary(16) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_person']['singleSRC'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_person']['singleSRC'],
            'exclude' => false,
            'inputType' => 'fileTree',
            'eval' => array('mandatory' => false, 'files' => true, 'fieldType' => 'radio', 'filesOnly' => true, 'extensions' => 'jpg,jpeg,png,gif', 'tl_class' => 'w50 clr')
        ),
    )
);

class tl_verband_person extends Backend
{

    public function __construct()
    {
        parent::__construct();
    }

    public function listContent($arrRow)
    {
        return '<div class="tl_content_left">' . $arrRow['nachname'] . ' </div>';
    }
}
