<?php

$GLOBALS['TL_DCA']['tl_verband_funktion'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary'
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 2,
            'fields' => array('funktion_intern'),
            'flag' => 1,
            'panelLayout' => 'search,limit'
        ),
        'label' => array
        (
            'fields' => array('funktion_intern'),
            'format' => '%s - #contact#',
            'label_callback' => array('tl_verband_funktion', 'personSuchen'),
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Select
    'select' => array
    (
        'buttons_callback' => array
        (
            array('tl_verband_funktion', 'addAliasButton')
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{funktion_legende},funktion_intern,funktion_name,alias;{person_legende},person'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'funktion_intern' => array
        (
            'sql' => "varchar(64) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['funktion_intern'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['funktion_intern'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'eval' => array('mandatory' => true, 'minlength' => 1, 'maxlength' => 64, 'tl_class' => 'w50')
        ),
        'funktion_name' => array
        (
            'sql' => "varchar(64) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['funktion_name'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['funktion_name'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'eval' => array('mandatory' => true, 'minlength' => 1, 'maxlength' => 64, 'tl_class' => 'w50')
        ),
        'alias' => array
        (
            'sql' => "varbinary(128) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['alias'],
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('rgxp' => 'alias', 'maxlength' => 128, 'tl_class' => 'w50'),
            'save_callback' => array
            (
                array('tl_verband_funktion', 'aliasGenerieren')
            ),
        ),
        'person' => array
        (
            'sql' => "int(10) unsigned NULL",
            'foreignKey' => 'tl_verband_person.id',
            'relation' => array('type' => 'hasOne', 'load' => 'eager'),
            'label' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['person'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_funktion']['person'],
            'exclude' => false,
            'inputType' => 'select',
            'options_callback' => array('tl_verband_funktion', 'ladePersonen'),
            'eval' => array('chosen' => true, 'includeBlankOption' => true, 'mandatory' => false, 'tl_class' => 'w50')
        )
    )
);

class tl_verband_funktion extends Backend
{
    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public function aliasGenerieren($varValue, DataContainer $dc)
    {
        if ($varValue == '') {
            $varValue = standardize(StringUtil::restoreBasicEntities($dc->activeRecord->funktion_name));
        }
        $objAlias = $this->Database->prepare("SELECT id FROM tl_verband_funktion WHERE alias=?")->execute($varValue);
        if ($objAlias->numRows > 0) {
            if ($objAlias->next()->id != $dc->id) {
                $varValue .= '-' . $dc->id;
            }
        }
        return $varValue;
    }

    public function addAliasButton($arrButtons)
    {
        if (Input::post('FORM_SUBMIT') == 'tl_select' && isset($_POST['alias'])) {
            $session = $this->Session->getData();
            $ids = $session['CURRENT']['IDS'];

            foreach ($ids as $id) {
                $objFunktion = \HHIT\VerbandOrgBundle\Model\FunktionModel::findByPk($id);

                if ($objFunktion === null) {
                    continue;
                }

                // Set the new alias
                $strAlias = standardize(StringUtil::restoreBasicEntities($objFunktion->funktion_name));

                // Check if alias exists
                $objAlias = $this->Database->prepare("SELECT id FROM tl_verband_funktion WHERE alias=?")
                    ->execute($strAlias);
                if ($objAlias->numRows > 1) {
                    $strAlias .= '-' . $objFunktion->id;
                }

                // The alias has not changed
                if ($strAlias == $objFunktion->alias) {
                    continue;
                }

                // Initialize the version manager
                $objVersions = new Versions('tl_verband_funktion', $id);
                $objVersions->initialize();

                // Store the new alias
                $this->Database->prepare("UPDATE tl_verband_funktion SET alias=? WHERE id=?")
                    ->execute($strAlias, $id);

                // Create a new version
                $objVersions->create();
                \Message::addInfo(sprintf('Alias für Funktion <strong>%1$s</strong> generiert.', $objFunktion->name));
            }

            $this->redirect($this->getReferer());
        }

        $arrButtons['verbandFunktionAlias'] = '<input type="submit" name="alias" id="alias" class="tl_submit" accesskey="a" value="' . specialchars($GLOBALS['TL_LANG']['MSC']['aliasSelected']) . '"> ';
        return $arrButtons;
    }

    public function ladePersonen()
    {
        $arrContacts = array();
        $objContact = $this->Database->prepare("SELECT id, vorname, nachname FROM tl_verband_person ORDER BY nachname, vorname")->execute();
        if ($objContact && $objContact->numRows > 0) {
            while ($objContact->next()) {
                $arrContacts[$objContact->id] = sprintf("%s, %s", $objContact->nachname, $objContact->vorname);
            }
        }
        return $arrContacts;
    }

    public function personSuchen($row, $label)
    {
        $contact_id = $row['person'];
        $objContact = $this->Database->prepare("SELECT vorname, nachname FROM tl_verband_person WHERE id = ?")->execute($contact_id);
        if ($objContact && $objContact->numRows > 0) {
            return str_replace('#contact#', '<span style="color: green;">' . $objContact->vorname . ' ' . $objContact->nachname . '</span>', $label);
        } else {
            return str_replace('#contact#', '<span style="color: red; font-weight: bold;">nicht besetzt</span>', $label);
        }
    }
}
