<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\ModuleModel;
use Contao\StringUtil;
use Contao\Template;
use Model\Collection;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use HHIT\VerbandOrgBundle\Model\FunktionModel;
use HHIT\VerbandOrgBundle\Model\GremiumModel;

/**
 * @FrontendModule("verband_gremium_liste",
 *     category="verband",
 *     template="vb_funktion_anzeige",
 *     renderer="forward"
 * )
 */
class GremiumListeFrontendModuleController extends AbstractVerbandFrontendModuleController
{
    use FunktionJumpToLinkTrait, FunktionImageTrait;

    private static $defaultEntryTemplate = 'vb_gremium_eintrag_full';

    public function __construct(ContaoFramework $framework)
    {
        parent::__construct($framework);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        if ($model->verband_gremium_template && $template->getName() !== $model->verband_gremium_template) {
            $template->setName($model->verband_gremium_template);
        }

        $this->loadLanguageFiles(['tl_verband_fe', 'tl_verband_gremium_fe', 'tl_verband_funktion_fe', 'tl_verband_person_fe']);

        if ($model->verband_gremium && ($gremium = GremiumModel::findByPk($model->verband_gremium))) {
            /**
             * @var GremiumModel $gremium
             */
            $template->gremium = $gremium;
            $template->layout = $template->getName();
            $this->addMembers($gremium->mitglieder, $model, $template);
        }

        return $template->getResponse()->setPrivate();
    }

    private function addMembers(\Contao\Model\Collection $funktionen = null, ModuleModel $model, Template $template): void
    {
        $template->hasDetailsLink = $model->jumpTo ? true : false;
        $showImage = (bool)$model->verband_funktion_image;
        $members = [];

        if ($funktionen) {
            $template->propertiesToShow = [];
            if ($model->verband_gremium_vars) {
                $template->propertiesToShow = StringUtil::deserialize($model->verband_gremium_vars, true);
            }

            // TODO: wird das noch gebraucht?
            $strPlaceholderStyle = null;

            $index = 0;
            foreach ($funktionen as $funktion) {
                /**
                 * @var FunktionModel $funktion
                 */
                if ($model->jumpTo) {
                    $funktion->detailsUrl = $this->buildJumpToLink($funktion, $model);
                }

                $entryTemplate = new FrontendTemplate($model->verband_gremium_eintrag_template ? $model->verband_gremium_eintrag_template : self::$defaultEntryTemplate);
                $entryTemplate->index = $index;
                $entryTemplate->funktion = $funktion;
                $entryTemplate->propertiesToShow = $template->propertiesToShow;
                $entryTemplate->showImage = $showImage;
                $entryTemplate->placeholderStyle = $strPlaceholderStyle;
                $entryTemplate->hasImage = false;

                if ($showImage && $funktion->besetzt) {
                    $this->addImage($funktion, $this->getContainer(), $model, $entryTemplate);
                }
                $members[] = $entryTemplate->parse();
                $index++;
            }
            $funktionen->reset();
        }

        $template->mitglieder = $members;
    }
}
