<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\ContentModel;
use Contao\Controller;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\Adapter;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\Image\ImageFactoryInterface;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FilesModel;
use Contao\Input;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\StringUtil;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use HHIT\VerbandOrgBundle\Model\FunktionModel;
use HHIT\VerbandOrgBundle\Model\PersonModel;

/**
 * @FrontendModule("verband_funktion_leser",
 *     category="verband",
 *     template="vb_funktion_leser",
 *     renderer="forward"
 * )
 */
class FunktionLeserFrontendModuleController extends AbstractVerbandFrontendModuleController
{
    use FunktionJumpToLinkTrait, FunktionImageTrait, FunktionContentTrait;

    public function __construct(ContaoFramework $framework)
    {
        parent::__construct($framework);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $funktion = $this->loadRequestedFunktion($request);
        if ($funktion) {
            if ($model->verband_funktion_template && $template->getName() !== $model->verband_funktion_template) {
                $template->setName($model->verband_funktion_template);
            }

            $this->loadLanguageFiles(['tl_verband_fe', 'tl_verband_funktion_fe', 'tl_verband_person_fe']);
            return $this->processFunktion($funktion, $template, $model)->setPrivate();
        } else {
            throw $this->createNotFoundException('Funktion existiert nicht');
        }
    }

    private function getRequestedFunktion(Request $request): ?string
    {
        if ($this->isUseAutoItem()) {
            return $this->framework->getAdapter(Input::class)->get('auto_item');
        } else {
            return $this->framework->getAdapter(Input::class)->get('funktion');
        }
    }

    private function loadRequestedFunktion(Request $request): ?FunktionModel
    {
        $funktionAlias = $this->getRequestedFunktion($request);
        if (!$funktionAlias) {
            return null;
        }
        return FunktionModel::findByIdOrAlias($funktionAlias);
    }

    private function processFunktion(FunktionModel $funktion, Template $template, ModuleModel $model): Response
    {
        $template->funktion = $funktion;
        if ($funktion->besetzt) {
            $this->getPageModel()->title = $this->getPageModel()->title . ': ' . $funktion->name;
            $this->addImage($funktion, $this->getContainer(), $model, $template);
            $this->addContent($funktion, $template);
        }
        return $template->getResponse();
    }
}
