<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\ModuleModel;
use Contao\PageModel;
use Contao\Template;
use HHIT\VerbandOrgBundle\Model\FunktionModel;

trait FunktionJumpToLinkTrait
{
    private function addJumpToLink(FunktionModel $funktion, ModuleModel $model, Template $template): void
    {
        if ($link = $this->buildJumpToLink($funktion, $model)) {
            $template->detailsUrl = $link;
        }
    }

    private function buildJumpToLink(FunktionModel $funktion, ModuleModel $model): ?string
    {
        if ($model->jumpTo && ($targetPage = $model->getRelated('jumpTo'))) {
            /**
             * @var PageModel $targetPage
             */
            return $targetPage->getFrontendUrl($this->isUseAutoItem() ?
                "/{$funktion->getAlias()}" : "/funktion/{$funktion->getAlias()}");
        } else {
            return null;
        }
    }

    protected abstract function isUseAutoItem(): bool;
}
