<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\Controller;
use Contao\FilesModel;
use Contao\ModuleModel;
use Contao\Template;
use Contao\StringUtil;
use Psr\Container\ContainerInterface;
use HHIT\VerbandOrgBundle\Model\FunktionModel;

trait FunktionImageTrait
{
    private function addImage(FunktionModel $funktion, ContainerInterface $container, ModuleModel $model, Template $template): void
    {
        $template->showImage = (bool)$model->verband_funktion_image;
        $template->hasImage = false;
        if ($template->showImage && $funktion->person && $funktion->person->singleSRC) {
            $fileModel = FilesModel::findById($funktion->person->singleSRC);
            if ($fileModel && is_file($this->getAbsoluteFilePath($container, $fileModel))) {
                Controller::addImageToTemplate($template, ['singleSRC' => $fileModel->path, 'size' => $model->imgSize, 'floating' => $model->verband_funktion_float]);
                $template->hasImage = true;
            }
        }
        if ($template->showImage && !$template->hasImage) {
            $size = StringUtil::deserialize($model->imgSize);
            $placeholderStyle = '';
            if ($size !== null && $size[0] > 0) {
                $placeholderStyle .= 'width:' . $size[0] . 'px;';
            }
            if ($size !== null && $size[1] > 0) {
                $placeholderStyle .= 'height:' . $size[1] . 'px;';
            }
            if ($size) {
                $placeholderStyle = 'style="' . $placeholderStyle . '"';
            }
            $template->placeholderStyle = $placeholderStyle;
        }
    }

    private function getAbsoluteFilePath(ContainerInterface $container, FilesModel $file): string
    {
        return $container->getParameter('kernel.project_dir') . '/' . $file->path;
    }
}
