<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\ContentModel;
use Contao\Controller;
use Contao\Template;
use HHIT\VerbandOrgBundle\Model\FunktionModel;
use HHIT\VerbandOrgBundle\Model\PersonModel;

trait FunktionContentTrait
{
    private function addContent(FunktionModel $funktion, Template $template): void
    {
        if ($funktion->person) {
            $contentElement = ContentModel::findPublishedByPidAndTable($funktion->person->id, PersonModel::getTable());
            if ($contentElement !== null) {
                while ($contentElement->next()) {
                    $template->content .= Controller::getContentElement($contentElement->id);
                }
            }
        }
    }
}
