<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use HHIT\VerbandOrgBundle\Model\FunktionModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("verband_funktion_anzeige",
 *     category="verband",
 *     template="vb_funktion_anzeige",
 *     renderer="forward"
 * )
 */
class FunktionAnzeigeFrontendModuleController extends AbstractVerbandFrontendModuleController
{
    use FunktionJumpToLinkTrait, FunktionImageTrait, FunktionContentTrait;

    public function __construct(ContaoFramework $framework)
    {
        parent::__construct($framework);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        if ($model->verband_funktion_template && $template->getName() !== $model->verband_funktion_template) {
            $template->setName($model->verband_funktion_template);
        }

        if ($model->verband_funktion && ($funktion = FunktionModel::findByPk($model->verband_funktion))) {
            $this->loadLanguageFiles(['tl_verband_fe', 'tl_verband_funktion_fe', 'tl_verband_person_fe']);
            return $this->processFunktion($funktion, $template, $model)->setPrivate();
        } else {
            return $template->getResponse()->setPrivate();
        }
    }

    private function processFunktion(FunktionModel $funktion, Template $template, ModuleModel $model): Response
    {
        $template->funktion = $funktion;
        if ($funktion->besetzt) {
            $this->addJumpToLink($funktion, $model, $template);
            $this->addImage($funktion, $this->getContainer(), $model, $template);
            $this->addContent($funktion, $template);
        }
        return $template->getResponse();
    }
}
