<?php
declare(strict_types=1);

namespace HHIT\VerbandOrgBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\Adapter;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\Input;
use Contao\System;
use Psr\Container\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractVerbandFrontendModuleController extends AbstractFrontendModuleController
{
    protected ContaoFramework $framework;

    protected function __construct(ContaoFramework $framework)
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
    }

    protected function getConfig(): Adapter
    {
        return $this->framework->getAdapter(Config::class);
    }

    protected function isUseAutoItem(): bool
    {
        return (bool)$this->getConfig()->get('useAutoItem');
    }

    protected function loadLanguageFiles(array $files): void
    {
        $system = $this->framework->getAdapter(System::class);
        foreach ($files as $file) {
            $system->loadLanguageFile($file);
        }
    }

    protected function getContainer(): ContainerInterface
    {
        return $this->framework->getAdapter(System::class)->getContainer();
    }
}
